/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;

public class HistoryCommands {
    @Command(aliases={"/undo", "undo"}, usage="[times]", desc="Undoes the last action", min=0, max=1)
    @CommandPermissions(value={"worldedit.history.undo"})
    public static void undo(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int times = Math.max(1, args.getInteger(0, 1));
        for (int i = 0; i < times; ++i) {
            EditSession undone = session.undo(session.getBlockBag(player));
            if (undone == null) {
                player.printError("Nothing left to undo.");
                break;
            }
            player.print("Undo successful.");
            we.flushBlockBag(player, undone);
        }
    }

    @Command(aliases={"/redo", "redo"}, usage="[times]", desc="Redoes the last action (from history)", min=0, max=1)
    @CommandPermissions(value={"worldedit.history.redo"})
    public static void redo(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int times = Math.max(1, args.getInteger(0, 1));
        for (int i = 0; i < times; ++i) {
            EditSession redone = session.redo(session.getBlockBag(player));
            if (redone != null) {
                player.print("Redo successful.");
                we.flushBlockBag(player, redone);
                continue;
            }
            player.printError("Nothing left to redo.");
        }
    }

    @Command(aliases={"clearhistory"}, usage="", desc="Clear your history", min=0, max=0)
    @CommandPermissions(value={"worldedit.history.clear"})
    public static void clearHistory(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.clearHistory();
        player.print("History cleared.");
    }
}

