/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionBackend;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.bukkit.commands.PermissionsCommand;
import ru.tehkode.permissions.commands.Command;
import ru.tehkode.permissions.config.Configuration;

public class UtilityCommands
extends PermissionsCommand {
    @Command(name="pex", syntax="reload", permission="permissions.manage.reload", description="Reload environment")
    public void reload(Plugin plugin, CommandSender sender, Map<String, String> args) {
        PermissionsEx.getPermissionManager().reset();
        sender.sendMessage(ChatColor.WHITE + "Permissions reloaded");
    }

    @Command(name="pex", syntax="config <node> [value]", permission="permissions.manage.config", description="Print or set <node> [value]")
    public void config(Plugin plugin, CommandSender sender, Map<String, String> args) {
        Object node;
        if (!(plugin instanceof PermissionsEx)) {
            return;
        }
        String nodeName = args.get("node");
        if (nodeName == null || nodeName.isEmpty()) {
            return;
        }
        Configuration config = ((PermissionsEx)plugin).getConfig();
        if (args.get("value") != null) {
            config.setProperty(nodeName, this.parseValue(args.get("value")));
            config.save();
        }
        if ((node = config.getProperty(nodeName)) instanceof Map) {
            sender.sendMessage("Node \"" + nodeName + "\": ");
            for (Map.Entry entry : ((Map)node).entrySet()) {
                sender.sendMessage("  " + (String)entry.getKey() + " = " + entry.getValue());
            }
        } else if (node instanceof List) {
            sender.sendMessage("Node \"" + nodeName + "\": ");
            for (String item : (List)node) {
                sender.sendMessage(" - " + item);
            }
        } else {
            sender.sendMessage("Node \"" + nodeName + "\" = \"" + node + "\"");
        }
    }

    @Command(name="pex", syntax="backend", permission="permissions.manage.backend", description="Print currently used backend")
    public void getBackend(Plugin plugin, CommandSender sender, Map<String, String> args) {
        sender.sendMessage("Current backend: " + PermissionsEx.getPermissionManager().getBackend());
    }

    @Command(name="pex", syntax="backend <backend>", permission="permissions.manage.backend", description="Change permission backend on the fly (Use with caution!)")
    public void setBackend(Plugin plugin, CommandSender sender, Map<String, String> args) {
        if (args.get("backend") == null) {
            return;
        }
        try {
            PermissionsEx.getPermissionManager().setBackend(args.get("backend"));
            sender.sendMessage(ChatColor.WHITE + "Permission backend changed!");
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                sender.sendMessage(ChatColor.RED + "Specified backend not found.");
            }
            sender.sendMessage(ChatColor.RED + "Error during backend initialization.");
            e.printStackTrace();
        }
    }

    @Command(name="pex", syntax="hierarchy [world]", permission="permissions.manage.users", description="Print complete user/group hierarchy")
    public void printHierarhy(Plugin plugin, CommandSender sender, Map<String, String> args) {
        sender.sendMessage("User/Group inheritance hierarchy:");
        this.sendMessage(sender, this.printHierarchy(null, this.autoCompleteWorldName(args.get("world")), 0));
    }

    @Command(name="pex", syntax="dump <backend> <filename>", permission="permissions.dump", description="Dump users/groups to selected <backend> format")
    public void dumpData(Plugin plugin, CommandSender sender, Map<String, String> args) {
        if (!(plugin instanceof PermissionsEx)) {
            return;
        }
        try {
            PermissionBackend backend = PermissionBackend.getBackend(args.get("backend"), PermissionsEx.getPermissionManager(), ((PermissionsEx)plugin).getConfig(), null);
            File dstFile = new File("plugins/PermissionsEx/", args.get("filename"));
            FileOutputStream outStream = new FileOutputStream(dstFile);
            backend.dumpData(new OutputStreamWriter((OutputStream)outStream, "UTF-8"));
            outStream.close();
            sender.sendMessage(ChatColor.WHITE + "[PermissionsEx] Data dumped in \"" + dstFile.getName() + "\" ");
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                sender.sendMessage(ChatColor.RED + "Specified backend not found!");
            } else {
                sender.sendMessage(ChatColor.RED + "Error: " + e.getMessage());
                logger.severe("Error: " + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            sender.sendMessage(ChatColor.RED + "IO Error: " + e.getMessage());
        }
    }

    @Command(name="pex", syntax="toggle debug", permission="permissions.manage", description="Enable/disable debug mode")
    public void toggleFeature(Plugin plugin, CommandSender sender, Map<String, String> args) {
        PermissionManager manager;
        manager.setDebug(!(manager = PermissionsEx.getPermissionManager()).isDebug());
        String debugStatusMessage = "[PermissionsEx] Debug mode " + (manager.isDebug() ? "enabled" : "disabled");
        if (sender instanceof Player) {
            sender.sendMessage(debugStatusMessage);
        }
        logger.warning(debugStatusMessage);
    }
}

