/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import ru.tehkode.permissions.PermissionBackend;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.backends.FileBackend;
import ru.tehkode.permissions.backends.SQLBackend;
import ru.tehkode.permissions.bukkit.BukkitPermissions;
import ru.tehkode.permissions.bukkit.commands.GroupCommands;
import ru.tehkode.permissions.bukkit.commands.PromotionCommands;
import ru.tehkode.permissions.bukkit.commands.UserCommands;
import ru.tehkode.permissions.bukkit.commands.UtilityCommands;
import ru.tehkode.permissions.bukkit.commands.WorldCommands;
import ru.tehkode.permissions.commands.CommandsManager;
import ru.tehkode.permissions.config.Configuration;
import ru.tehkode.permissions.config.ConfigurationNode;

public class PermissionsEx
extends JavaPlugin {
    protected static final String configFile = "config.yml";
    protected static final Logger logger = Logger.getLogger("Minecraft");
    protected PermissionManager permissionsManager;
    protected CommandsManager commandsManager;
    protected Configuration config;
    protected BukkitPermissions superms;

    public PermissionsEx() {
        PermissionBackend.registerBackendAlias("sql", SQLBackend.class);
        PermissionBackend.registerBackendAlias("file", FileBackend.class);
        logger.log(Level.INFO, "[PermissionsEx] PermissionEx plugin initialized.");
    }

    public void onLoad() {
        this.config = this.loadConfig(configFile);
        this.commandsManager = new CommandsManager((Plugin)this);
        this.permissionsManager = new PermissionManager(this.config);
    }

    public void onEnable() {
        this.commandsManager.register(new UtilityCommands());
        this.commandsManager.register(new UserCommands());
        this.commandsManager.register(new GroupCommands());
        this.commandsManager.register(new PromotionCommands());
        this.commandsManager.register(new WorldCommands());
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_QUIT, (Listener)new PlayerEventsListener(), Event.Priority.Normal, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_RESPAWN, (Listener)new PlayerEventsListener(), Event.Priority.Lowest, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)new PlayerEventsListener(), Event.Priority.Lowest, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_PORTAL, (Listener)new PlayerEventsListener(), Event.Priority.Lowest, (Plugin)this);
        this.getServer().getServicesManager().register(PermissionManager.class, (Object)this.permissionsManager, (Plugin)this, ServicePriority.Normal);
        ConfigurationNode dinnerpermsConfig = this.config.getNode("permissions.superperms");
        if (dinnerpermsConfig == null) {
            dinnerpermsConfig = Configuration.getEmptyNode();
            this.config.setProperty("permissions.superperms", (Object)dinnerpermsConfig);
        }
        this.superms = new BukkitPermissions((Plugin)this, dinnerpermsConfig);
        this.config.save();
        logger.log(Level.INFO, "[PermissionsEx] v" + this.getDescription().getVersion() + " enabled");
    }

    public void onDisable() {
        this.permissionsManager.reset();
        this.getServer().getServicesManager().unregister(PermissionManager.class, (Object)this.permissionsManager);
        logger.log(Level.INFO, "[PermissionsEx] v" + this.getDescription().getVersion() + " disabled successfully.");
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        PluginDescriptionFile pdf = this.getDescription();
        if (args.length > 0) {
            return this.commandsManager.execute(sender, command, args);
        }
        if (sender instanceof Player) {
            sender.sendMessage("[" + ChatColor.RED + "PermissionsEx" + ChatColor.WHITE + "] version [" + ChatColor.BLUE + pdf.getVersion() + ChatColor.WHITE + "]");
            return !this.permissionsManager.has((Player)sender, "permissions.manage");
        }
        sender.sendMessage("[PermissionsEx] version [" + pdf.getVersion() + "]");
        return false;
    }

    public static PermissionManager getPermissionManager() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("PermissionsEx");
        if (plugin == null || !(plugin instanceof PermissionsEx) || ((PermissionsEx)plugin).permissionsManager == null) {
            throw new RuntimeException("Permissions manager is not accessable. Is the PermissionsEx plugin enabled?");
        }
        return ((PermissionsEx)plugin).permissionsManager;
    }

    public boolean has(Player player, String permission) {
        return this.permissionsManager.has(player, permission);
    }

    public boolean has(Player player, String permission, String world) {
        return this.permissionsManager.has(player, permission, world);
    }

    public Configuration getConfig() {
        return this.config;
    }

    protected final Configuration loadConfig(String name) {
        Configuration configuration;
        File configurationFile;
        File dataFolder = this.getDataFolder();
        if (dataFolder == null) {
            dataFolder = new File("plugins/PermissionsEx/");
        }
        if (!(configurationFile = new File(dataFolder, configFile)).exists()) {
            try {
                if (!dataFolder.exists()) {
                    dataFolder.mkdirs();
                }
                configurationFile.createNewFile();
                configuration = new Configuration(configurationFile);
                configuration.setProperty("permissions.basedir", dataFolder.getPath());
                configuration.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            configuration = new Configuration(configurationFile);
            configuration.load();
        }
        return configuration;
    }

    protected class PlayerEventsListener
    extends PlayerListener {
        protected PlayerEventsListener() {
        }

        public void onPlayerQuit(PlayerQuitEvent event) {
            PermissionsEx.getPermissionManager().resetUser(event.getPlayer().getName());
        }

        protected void clearUserCache(PlayerEvent event) {
            PermissionsEx.getPermissionManager().clearUserCache(event.getPlayer());
        }

        public void onPlayerPortal(PlayerPortalEvent event) {
            this.clearUserCache((PlayerEvent)event);
        }

        public void onPlayerRespawn(PlayerRespawnEvent event) {
            this.clearUserCache((PlayerEvent)event);
        }

        public void onPlayerTeleport(PlayerTeleportEvent event) {
            this.clearUserCache((PlayerEvent)event);
        }
    }
}

