/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.CustomEventListener;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerListener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.config.ConfigurationNode;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;

public class BukkitPermissions {
    protected static final Logger logger = Logger.getLogger("Minecraft");
    protected Map<Player, PermissionAttachment> attachments = new HashMap<Player, PermissionAttachment>();
    protected Set<Permission> registeredPermissions = new HashSet<Permission>();
    protected Plugin plugin;
    protected boolean dumpAllPermissions = true;
    protected boolean dumpMatchedPermissions = true;
    protected boolean disableByDefault = false;

    public BukkitPermissions(Plugin plugin, ConfigurationNode config) {
        this.plugin = plugin;
        if (!config.getBoolean("enable", true)) {
            logger.info("[PermissionsEx] Superperms disabled. Check \"config.yml\" to enable.");
            return;
        }
        this.dumpAllPermissions = config.getBoolean("raw-permissions", this.dumpAllPermissions);
        this.dumpMatchedPermissions = config.getBoolean("matched-permissions", this.dumpMatchedPermissions);
        this.disableByDefault = config.getBoolean("disable-unmatched", this.disableByDefault);
        this.collectPermissions();
        this.registerEvents();
        this.updateAllPlayers();
        logger.info("[PermissionsEx] Superperms support enabled.");
    }

    private void registerEvents() {
        PluginManager manager = this.plugin.getServer().getPluginManager();
        PlayerEvents playerEventListener = new PlayerEvents();
        manager.registerEvent(Event.Type.PLAYER_JOIN, (Listener)playerEventListener, Event.Priority.Normal, this.plugin);
        manager.registerEvent(Event.Type.PLAYER_KICK, (Listener)playerEventListener, Event.Priority.Normal, this.plugin);
        manager.registerEvent(Event.Type.PLAYER_QUIT, (Listener)playerEventListener, Event.Priority.Normal, this.plugin);
        manager.registerEvent(Event.Type.PLAYER_RESPAWN, (Listener)playerEventListener, Event.Priority.Normal, this.plugin);
        manager.registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)playerEventListener, Event.Priority.Normal, this.plugin);
        manager.registerEvent(Event.Type.PLAYER_PORTAL, (Listener)playerEventListener, Event.Priority.Normal, this.plugin);
        manager.registerEvent(Event.Type.CUSTOM_EVENT, (Listener)new PEXEvents(), Event.Priority.Normal, this.plugin);
        BukkitEvents serverListener = new BukkitEvents();
        manager.registerEvent(Event.Type.PLUGIN_ENABLE, (Listener)serverListener, Event.Priority.Normal, this.plugin);
        manager.registerEvent(Event.Type.PLUGIN_DISABLE, (Listener)serverListener, Event.Priority.Normal, this.plugin);
    }

    private void collectPermissions() {
        this.registeredPermissions.clear();
        for (Plugin bukkitPlugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            this.registeredPermissions.addAll(bukkitPlugin.getDescription().getPermissions());
        }
    }

    protected void updatePermissions(Player player) {
        this.updatePermissions(player, null);
    }

    protected void updatePermissions(Player player, String world) {
        if (player == null) {
            return;
        }
        if (!this.attachments.containsKey(player)) {
            this.attachments.put(player, player.addAttachment(this.plugin));
        }
        if (world == null) {
            world = player.getWorld().getName();
        }
        PermissionAttachment attachment = this.attachments.get(player);
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(player);
        String[] permissions = user.getPermissions(world);
        for (String string : attachment.getPermissions().keySet()) {
            attachment.unsetPermission(string);
        }
        if (this.dumpMatchedPermissions) {
            for (Permission permission : this.registeredPermissions) {
                String matchingExpression = user.getMatchingExpression(permissions, permission.getName());
                boolean permissionValue = user.explainExpression(matchingExpression);
                if (!this.disableByDefault && matchingExpression == null) continue;
                attachment.setPermission(permission, permissionValue);
            }
        }
        if (this.dumpAllPermissions) {
            for (String permission : permissions) {
                Boolean value = true;
                if (permission.startsWith("-")) {
                    permission = permission.substring(1);
                    value = false;
                }
                if (attachment.getPermissions().containsKey(permission)) continue;
                attachment.setPermission(permission, value.booleanValue());
            }
        }
        player.recalculatePermissions();
        if (PermissionsEx.getPermissionManager().isDebug()) {
            PermissionsEx.logger.info("[PermissionsEx-Dinnerperms] Player " + player.getName() + " for \"" + player.getWorld().getName() + "\" world permissions updated!");
        }
    }

    protected void updateAllPlayers() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.updatePermissions(player);
        }
    }

    protected class PEXEvents
    extends CustomEventListener {
        protected PEXEvents() {
        }

        public void onCustomEvent(Event event) {
            if (event instanceof PermissionEntityEvent) {
                PermissionEntityEvent pee = (PermissionEntityEvent)event;
                if (pee.getEntity() instanceof PermissionUser) {
                    BukkitPermissions.this.updatePermissions(Bukkit.getServer().getPlayer(pee.getEntity().getName()));
                } else if (pee.getEntity() instanceof PermissionGroup) {
                    for (PermissionUser user : PermissionsEx.getPermissionManager().getUsers(pee.getEntity().getName(), true)) {
                        BukkitPermissions.this.updatePermissions(Bukkit.getServer().getPlayer(user.getName()));
                    }
                }
            } else if (event instanceof PermissionSystemEvent) {
                BukkitPermissions.this.updateAllPlayers();
            }
        }
    }

    protected class BukkitEvents
    extends ServerListener {
        protected BukkitEvents() {
        }

        public void onPluginEnable(PluginEnableEvent event) {
            BukkitPermissions.this.collectPermissions();
            BukkitPermissions.this.updateAllPlayers();
        }

        public void onPluginDisable(PluginDisableEvent event) {
            BukkitPermissions.this.collectPermissions();
            BukkitPermissions.this.updateAllPlayers();
        }
    }

    protected class PlayerEvents
    extends PlayerListener {
        protected PlayerEvents() {
        }

        public void onPlayerJoin(PlayerJoinEvent event) {
            BukkitPermissions.this.updatePermissions(event.getPlayer());
        }

        public void onPlayerPortal(PlayerPortalEvent event) {
            BukkitPermissions.this.updatePermissions(event.getPlayer(), event.getTo().getWorld().getName());
        }

        public void onPlayerRespawn(PlayerRespawnEvent event) {
            BukkitPermissions.this.updatePermissions(event.getPlayer(), event.getRespawnLocation().getWorld().getName());
        }

        public void onPlayerTeleport(PlayerTeleportEvent event) {
            if (!event.getFrom().getWorld().equals(event.getTo().getWorld())) {
                BukkitPermissions.this.updatePermissions(event.getPlayer(), event.getTo().getWorld().getName());
            }
        }

        public void onPlayerQuit(PlayerQuitEvent event) {
            BukkitPermissions.this.attachments.remove(event.getPlayer());
        }

        public void onPlayerKick(PlayerKickEvent event) {
            BukkitPermissions.this.attachments.remove(event.getPlayer());
        }
    }
}

