/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends.file;

import java.util.Arrays;
import java.util.LinkedList;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.ProxyPermissionGroup;
import ru.tehkode.permissions.backends.FileBackend;
import ru.tehkode.permissions.backends.file.FileEntity;
import ru.tehkode.permissions.config.ConfigurationNode;
import ru.tehkode.permissions.events.PermissionEntityEvent;

public class FileGroup
extends ProxyPermissionGroup {
    protected ConfigurationNode node;

    public FileGroup(String name, PermissionManager manager, FileBackend backend) {
        super(new FileEntity(name, manager, backend, "groups"));
        this.node = ((FileEntity)this.backendEntity).getConfigNode();
    }

    @Override
    public String[] getParentGroupsNamesImpl(String worldName) {
        String inheritanceNode = "inheritance";
        if (worldName != null && !worldName.isEmpty()) {
            inheritanceNode = "worlds." + worldName + "." + inheritanceNode;
        }
        return this.node.getStringList(inheritanceNode, new LinkedList()).toArray(new String[0]);
    }

    @Override
    public void setParentGroups(String[] parentGroups, String worldName) {
        if (parentGroups == null) {
            return;
        }
        String inheritanceNode = "inheritance";
        if (worldName != null && !worldName.isEmpty()) {
            inheritanceNode = "worlds." + worldName + "." + inheritanceNode;
        }
        this.node.setProperty(inheritanceNode, Arrays.asList(parentGroups));
        this.save();
        this.callEvent(PermissionEntityEvent.Action.INHERITANCE_CHANGED);
    }
}

