/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.backends;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;
import ru.tehkode.permissions.PermissionBackend;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.backends.file.FileGroup;
import ru.tehkode.permissions.backends.file.FileUser;
import ru.tehkode.permissions.config.Configuration;
import ru.tehkode.permissions.config.ConfigurationNode;

public class FileBackend
extends PermissionBackend {
    public Configuration permissions;

    public FileBackend(PermissionManager manager, Configuration config) {
        super(manager, config);
    }

    @Override
    public void initialize() {
        File baseDirectory;
        String baseDir;
        String permissionFilename = this.config.getString("permissions.backends.file.file");
        if (permissionFilename == null) {
            permissionFilename = "permissions.yml";
            this.config.setProperty("permissions.backends.file.file", "permissions.yml");
            this.config.save();
        }
        if ((baseDir = this.config.getString("permissions.basedir")).contains("\\") && !"\\".equals(File.separator)) {
            baseDir = baseDir.replace("\\", File.separator);
        }
        if (!(baseDirectory = new File(baseDir)).exists()) {
            baseDirectory.mkdirs();
        }
        File permissionFile = new File(baseDir, permissionFilename);
        this.permissions = new Configuration(permissionFile);
        if (!permissionFile.exists()) {
            try {
                permissionFile.createNewFile();
                this.permissions.setProperty("groups.default.default", true);
                LinkedList<String> defaultPermissions = new LinkedList<String>();
                defaultPermissions.add("modifyworld.*");
                this.permissions.setProperty("groups.default.permissions", defaultPermissions);
                this.permissions.save();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.permissions.load();
    }

    @Override
    public String[] getWorldInheritance(String world) {
        if (world != null && !world.isEmpty()) {
            return this.permissions.getStringList("worlds." + world + ".inheritance", new LinkedList()).toArray(new String[0]);
        }
        return new String[0];
    }

    @Override
    public void setWorldInheritance(String world, String[] parentWorlds) {
        if (world == null && world.isEmpty()) {
            return;
        }
        this.permissions.setProperty("worlds." + world + ".inheritance", Arrays.asList(parentWorlds));
        this.permissions.save();
    }

    @Override
    public PermissionUser getUser(String userName) {
        return new FileUser(userName, this.manager, this);
    }

    @Override
    public PermissionGroup getGroup(String groupName) {
        return new FileGroup(groupName, this.manager, this);
    }

    @Override
    public PermissionGroup getDefaultGroup(String worldName) {
        Map<String, ConfigurationNode> groupsMap = this.permissions.getNodesMap("groups");
        if (groupsMap == null || groupsMap.isEmpty()) {
            throw new RuntimeException("No groups defined. Check your permissions file.");
        }
        String defaultGroupProperty = "default";
        if (worldName != null) {
            defaultGroupProperty = "worlds." + worldName + "." + defaultGroupProperty;
        }
        for (Map.Entry<String, ConfigurationNode> entry : groupsMap.entrySet()) {
            Object property = entry.getValue().getProperty(defaultGroupProperty);
            if (!(property instanceof Boolean) || !((Boolean)property).booleanValue()) continue;
            return this.manager.getGroup(entry.getKey());
        }
        if (worldName == null) {
            throw new RuntimeException("Default user group are not defined. Please select one using \"default: true\" property");
        }
        return null;
    }

    @Override
    public void setDefaultGroup(PermissionGroup group, String worldName) {
        Map<String, ConfigurationNode> groupsMap = this.permissions.getNodesMap("groups");
        String defaultGroupProperty = "default";
        if (worldName != null) {
            defaultGroupProperty = "worlds." + worldName + "." + defaultGroupProperty;
        }
        for (Map.Entry<String, ConfigurationNode> entry : groupsMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(group.getName()) && entry.getValue().getProperty(defaultGroupProperty) != null) {
                entry.getValue().removeProperty(defaultGroupProperty);
            }
            if (!entry.getKey().equalsIgnoreCase(group.getName())) continue;
            entry.getValue().setProperty(defaultGroupProperty, true);
        }
        this.permissions.save();
    }

    @Override
    public PermissionGroup[] getGroups() {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        Map<String, ConfigurationNode> groupsMap = this.permissions.getNodesMap("groups");
        for (Map.Entry<String, ConfigurationNode> entry : groupsMap.entrySet()) {
            groups.add(this.manager.getGroup(entry.getKey()));
        }
        Collections.sort(groups);
        return groups.toArray(new PermissionGroup[0]);
    }

    @Override
    public PermissionUser[] getRegisteredUsers() {
        LinkedList<PermissionUser> users = new LinkedList<PermissionUser>();
        Map<String, ConfigurationNode> userMap = this.permissions.getNodesMap("users");
        if (userMap != null) {
            for (Map.Entry<String, ConfigurationNode> entry : userMap.entrySet()) {
                users.add(this.manager.getUser(entry.getKey()));
            }
        }
        return users.toArray(new PermissionUser[0]);
    }

    @Override
    public void reload() {
        this.permissions.load();
    }

    public static Map<String, String> collectOptions(Map<String, Object> root) {
        return FileBackend.collectOptions(root, "", new HashMap<String, String>());
    }

    protected static Map<String, String> collectOptions(Map<String, Object> root, String baseKey, Map<String, String> collector) {
        for (Map.Entry<String, Object> entry : root.entrySet()) {
            String newKey = entry.getKey();
            if (baseKey != null && !baseKey.isEmpty()) {
                newKey = baseKey + "." + newKey;
            }
            if (entry.getValue() instanceof Map) {
                Map map = (Map)entry.getValue();
                FileBackend.collectOptions(map, newKey, collector);
                continue;
            }
            if (entry.getValue() instanceof ConfigurationNode) {
                FileBackend.collectOptions(((ConfigurationNode)((Object)entry.getValue())).getRoot(), newKey, collector);
                continue;
            }
            collector.put(newKey, (String)entry.getValue());
        }
        return collector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dumpData(OutputStreamWriter writer) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), options);
        ConfigurationNode root = new ConfigurationNode();
        for (PermissionUser user : this.manager.getUsers()) {
            if (user.getGroupsNames().length > 0) {
                root.setProperty("users." + user.getName() + ".group", Arrays.asList(user.getGroupsNames()));
            }
            if (user.getOwnPrefix() != null && !user.getOwnPrefix().isEmpty()) {
                root.setProperty("users." + user.getName() + ".prefix", user.getOwnPrefix());
            }
            if (user.getOwnSuffix() != null && !user.getOwnSuffix().isEmpty()) {
                root.setProperty("users." + user.getName() + ".suffix", user.getOwnSuffix());
            }
            for (Map.Entry<String, String[]> entry : user.getAllPermissions().entrySet()) {
                void var11_23;
                String string = "users." + user.getName();
                if (!entry.getKey().isEmpty()) {
                    String string2 = string + ".worlds." + entry.getKey();
                }
                String string3 = (String)var11_23 + ".permissions";
                if (entry.getValue().length <= 0) continue;
                root.setProperty(string3, Arrays.asList((Object[])entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : user.getAllOptions().entrySet()) {
                void var11_27;
                String string = "users." + user.getName();
                if (!entry.getKey().isEmpty()) {
                    String string4 = string + "worlds." + entry.getKey();
                }
                String string5 = (String)var11_27 + ".options";
                if (((Map)entry.getValue()).size() <= 0) continue;
                root.setProperty(string5, entry.getValue());
            }
        }
        PermissionGroup defaultGroup = this.manager.getDefaultGroup();
        for (PermissionGroup group : this.manager.getGroups()) {
            String nodePath;
            if (group.getParentGroupsNames().length > 0) {
                root.setProperty("groups." + group.getName() + ".inheritance", Arrays.asList(group.getParentGroupsNames()));
            }
            if (group.getOwnPrefix() != null && !group.getOwnPrefix().isEmpty()) {
                root.setProperty("groups." + group.getName() + ".prefix", group.getOwnPrefix());
            }
            if (group.getOwnSuffix() != null && !group.getOwnSuffix().isEmpty()) {
                root.setProperty("groups." + group.getName() + ".suffix", group.getOwnSuffix());
            }
            if (group.equals(defaultGroup)) {
                root.setProperty("groups." + group.getName() + ".default", true);
            }
            for (Map.Entry<String, String[]> entry : group.getAllPermissions().entrySet()) {
                nodePath = "groups." + group.getName();
                if (!entry.getKey().isEmpty()) {
                    nodePath = nodePath + ".worlds." + entry.getKey();
                }
                nodePath = nodePath + ".permissions";
                if (entry.getValue().length <= 0) continue;
                root.setProperty(nodePath, Arrays.asList((Object[])entry.getValue()));
            }
            for (Map.Entry<String, Map<String, String>> entry : group.getAllOptions().entrySet()) {
                nodePath = "groups." + group.getName();
                if (!entry.getKey().isEmpty()) {
                    nodePath = nodePath + "worlds." + entry.getKey();
                }
                nodePath = nodePath + ".options";
                if (entry.getValue().size() <= 0) continue;
                root.setProperty(nodePath, entry.getValue());
            }
        }
        for (World world : Bukkit.getServer().getWorlds()) {
            String[] parentWorlds = this.manager.getWorldInheritance(world.getName());
            if (parentWorlds.length == 0) continue;
            root.setProperty("worlds." + world.getName() + ".inheritance", Arrays.asList(parentWorlds));
        }
        yaml.dump(root.getRoot(), (Writer)writer);
    }
}

