/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.config.Configuration;

public abstract class PermissionBackend {
    protected static final String defaultBackend = "file";
    protected PermissionManager manager;
    protected Configuration config;
    protected static Map<String, Class<? extends PermissionBackend>> registedAliases = new HashMap<String, Class<? extends PermissionBackend>>();

    protected PermissionBackend(PermissionManager manager, Configuration config) {
        this.manager = manager;
        this.config = config;
    }

    public abstract void initialize();

    public abstract PermissionUser getUser(String var1);

    public abstract PermissionGroup getGroup(String var1);

    public PermissionGroup createGroup(String name) {
        return this.manager.getGroup(name);
    }

    public boolean removeGroup(String groupName) {
        if (this.getGroups(groupName).length > 0) {
            return false;
        }
        for (PermissionUser user : this.getUsers(groupName)) {
            user.removeGroup(groupName);
        }
        this.manager.getGroup(groupName).remove();
        return true;
    }

    public abstract PermissionGroup getDefaultGroup(String var1);

    public abstract void setDefaultGroup(PermissionGroup var1, String var2);

    public abstract String[] getWorldInheritance(String var1);

    public abstract void setWorldInheritance(String var1, String[] var2);

    public abstract PermissionGroup[] getGroups();

    public PermissionGroup[] getGroups(String groupName) {
        return this.getGroups(groupName, null);
    }

    public PermissionGroup[] getGroups(String groupName, String worldName) {
        return this.getGroups(groupName, worldName, false);
    }

    public PermissionGroup[] getGroups(String groupName, boolean inheritance) {
        HashSet<PermissionGroup> groups = new HashSet<PermissionGroup>();
        for (World world : Bukkit.getServer().getWorlds()) {
            groups.addAll(Arrays.asList(this.getGroups(groupName, world.getName(), inheritance)));
        }
        groups.addAll(Arrays.asList(this.getGroups(groupName, null, inheritance)));
        return groups.toArray(new PermissionGroup[0]);
    }

    public PermissionGroup[] getGroups(String groupName, String worldName, boolean inheritance) {
        LinkedList<PermissionGroup> groups = new LinkedList<PermissionGroup>();
        for (PermissionGroup group : this.getGroups()) {
            if (groups.contains(group) || !group.isChildOf(groupName, worldName, inheritance)) continue;
            groups.add(group);
        }
        return groups.toArray(new PermissionGroup[0]);
    }

    public PermissionUser[] getUsers() {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            users.add(this.manager.getUser(player));
        }
        users.addAll(Arrays.asList(this.getRegisteredUsers()));
        return users.toArray(new PermissionUser[0]);
    }

    public abstract PermissionUser[] getRegisteredUsers();

    public PermissionUser[] getUsers(String groupName) {
        return this.getUsers(groupName, false);
    }

    public PermissionUser[] getUsers(String groupName, String worldName) {
        return this.getUsers(groupName, worldName, false);
    }

    public PermissionUser[] getUsers(String groupName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getUsers()) {
            if (!user.inGroup(groupName, inheritance)) continue;
            users.add(user);
        }
        return users.toArray(new PermissionUser[0]);
    }

    public PermissionUser[] getUsers(String groupName, String worldName, boolean inheritance) {
        HashSet<PermissionUser> users = new HashSet<PermissionUser>();
        for (PermissionUser user : this.getUsers()) {
            if (!user.inGroup(groupName, worldName, inheritance)) continue;
            users.add(user);
        }
        return users.toArray(new PermissionUser[0]);
    }

    public abstract void reload();

    public abstract void dumpData(OutputStreamWriter var1) throws IOException;

    public static String getBackendClassName(String alias) {
        if (registedAliases.containsKey(alias)) {
            return registedAliases.get(alias).getName();
        }
        return alias;
    }

    public static Class<? extends PermissionBackend> getBackendClass(String alias) throws ClassNotFoundException {
        if (!registedAliases.containsKey(alias)) {
            return Class.forName(alias);
        }
        return registedAliases.get(alias);
    }

    public static void registerBackendAlias(String alias, Class<? extends PermissionBackend> backendClass) {
        if (!PermissionBackend.class.isAssignableFrom(backendClass)) {
            throw new RuntimeException("Provided class should be subclass of PermissionBackend");
        }
        registedAliases.put(alias, backendClass);
        Logger.getLogger("Minecraft").info("[PermissionsEx] " + alias + " backend registered!");
    }

    public static String getBackendAlias(Class<? extends PermissionBackend> backendClass) {
        if (registedAliases.containsValue(backendClass)) {
            for (String alias : registedAliases.keySet()) {
                if (!registedAliases.get(alias).equals(backendClass)) continue;
                return alias;
            }
        }
        return backendClass.getName();
    }

    public static PermissionBackend getBackend(String backendName, Configuration config) {
        return PermissionBackend.getBackend(backendName, PermissionsEx.getPermissionManager(), config, defaultBackend);
    }

    public static PermissionBackend getBackend(String backendName, PermissionManager manager, Configuration config) {
        return PermissionBackend.getBackend(backendName, manager, config, defaultBackend);
    }

    public static PermissionBackend getBackend(String backendName, PermissionManager manager, Configuration config, String fallBackBackend) {
        if (backendName == null || backendName.isEmpty()) {
            backendName = defaultBackend;
        }
        String className = PermissionBackend.getBackendClassName(backendName);
        try {
            Class<? extends PermissionBackend> backendClass = PermissionBackend.getBackendClass(backendName);
            Logger.getLogger("Minecraft").info("[PermissionsEx] Initializing " + backendName + " backend");
            Constructor<? extends PermissionBackend> constructor = backendClass.getConstructor(PermissionManager.class, Configuration.class);
            return constructor.newInstance(new Object[]{manager, config});
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("Minecraft").warning("[PermissionsEx] Specified backend \"" + backendName + "\" are not found.");
            if (fallBackBackend == null) {
                throw new RuntimeException(e);
            }
            if (!className.equals(PermissionBackend.getBackendClassName(fallBackBackend))) {
                return PermissionBackend.getBackend(fallBackBackend, manager, config, null);
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

